/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.target;

import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.managed.ObjectId;
import com.ibm.hwmca.fw.target.CommonTargetingTaskletExit;
import com.ibm.hwmca.fw.target.NextTargetsActionListener;
import com.ibm.hwmca.fw.target.Target;
import com.ibm.hwmca.fw.target.TargetActionListener;
import com.ibm.hwmca.fw.target.TargetBean;
import com.ibm.hwmca.fw.target.TargetRetriever;
import com.ibm.hwmca.fw.tasklet.PanelTasklet;
import com.ibm.hwmca.fw.util.HMCUserTaskManager;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.ui.framework.DataBean;
import com.ibm.ui.framework.TaskActionListener;
import com.ibm.ui.framework.TaskSelectionListener;
import com.ibm.ui.framework.UserTaskManager;
import java.util.Map;
import java.util.Properties;

public class CommonTargeting {
    private static final String TRACE_MASKT = "XCMTAPPT";
    private static final String TRACE_MASKF = "XCMTAPPF";
    private static final String TRACE_MASKD = "XCMTAPPD";
    private static final String AUIML_FILE_NAME = "com.ibm.hwmca.fw.target.res.TargetRes";
    private static final String PANEL_NAME = "TargetPanel";
    public static final int ACTION_PANEL = 1;
    public static final int SELECTION_PANEL = 2;
    private UserTaskManager utm;
    private TargetRetriever retriever;
    private int type;
    private String taskid;
    private boolean multiSelect = false;
    private Target[] selectedTargets = null;
    private TargetActionListener targetActionListener = null;
    private TargetBean bean;
    private boolean panelCompleted = false;
    private PanelTasklet panelTasklet = null;
    private Target[] retrieverTargets = null;

    public static CommonTargeting showTargetActionPanel(TargetRetriever retriever, String taskid, boolean multiSelect, PanelTasklet tasklet) throws HException {
        Trace.trace(TRACE_MASKT, "-> CommonTargeting.showTargetActionPanel()");
        CommonTargeting ct = new CommonTargeting(retriever, taskid, multiSelect, 1, null);
        ct.show(tasklet);
        Trace.trace(TRACE_MASKT, "<- CommonTargeting.showTargetActionPanel()");
        return ct;
    }

    public static CommonTargeting showTargetSelectionPanel(TargetRetriever retriever, String taskid, boolean multiSelect, PanelTasklet tasklet) throws HException {
        Trace.trace(TRACE_MASKT, "-> CommonTargeting.showTargetActionPanel()");
        CommonTargeting ct = new CommonTargeting(retriever, taskid, multiSelect, 2, null);
        ct.show(tasklet);
        Trace.trace(TRACE_MASKT, "<- CommonTargeting.showTargetActionPanel()");
        return ct;
    }

    CommonTargeting(TargetRetriever retriever, String taskid, boolean multiSelect, int type, Target[] targets) {
        Trace.trace(TRACE_MASKF, "-> CommonTargeting.ctor()");
        this.retriever = retriever;
        this.taskid = taskid;
        this.type = type;
        this.multiSelect = multiSelect;
        this.retrieverTargets = targets;
        Trace.trace(TRACE_MASKF, "<- CommonTargeting.ctor()");
    }

    void show(PanelTasklet tasklet) throws HException {
        Trace.trace(TRACE_MASKF, "-> CommonTargeting.show()");
        try {
            this.panelTasklet = tasklet;
            if (tasklet == null) {
                Properties panelProperties = null;
                if (this.retriever.getPanelHelpInfo(this.taskid) != null) {
                    panelProperties = new Properties();
                    panelProperties.put("@TargetPanel", this.retriever.getPanelHelpInfo(this.taskid));
                }
                this.bean = new TargetBean(this.retriever, this.taskid, this.type);
                this.utm = new HMCUserTaskManager(AUIML_FILE_NAME, panelProperties, PANEL_NAME, (Object[])new DataBean[]{this.bean}, null, null);
                this.bean.setUserTaskManager(this.utm);
                if (this.type == 1) {
                    this.utm.setShown("OKButton", false);
                    this.utm.setShown("SelectedMenu", true);
                    this.utm.setShown("ActionMenu", true);
                    this.utm.setNotifySelection("TargetTable", true);
                } else {
                    this.utm.setShown("OKButton", true);
                    this.utm.setEnabled("OKButton", false);
                    this.utm.setShown("menubar1", false);
                    this.utm.setShown("SelectedMenu", false);
                    this.utm.setShown("ActionMenu", false);
                    this.utm.setNotifySelection("TargetTable", true);
                }
                this.bean.load();
                this.utm.addCancelListener((TaskActionListener)this.bean);
                this.utm.addTaskActionListener((TaskActionListener)this.bean);
                if (this.retriever.getPanelHelpInfo(this.taskid) == null) {
                    this.utm.setEnabled("HelpButton", false);
                    this.utm.setEnabled("HelpMenu", false);
                    this.utm.setEnabled("HelpMenu.HelpItem", false);
                }
                if (this.multiSelect) {
                    this.utm.setAttribute("TargetTable", 16, "MULTIPLE");
                } else {
                    this.utm.setAttribute("TargetTable", 16, "SINGLE");
                }
                this.utm.addTaskSelectionListener((TaskSelectionListener)this.bean, "TargetTable");
                this.utm.setCaptionText("InfoLabel", this.retriever.getPanelText(null).toString());
                this.utm.setCaptionText(PANEL_NAME, this.retriever.getPanelTitle(null).toString());
                this.utm.invoke();
                this.selectedTargets = this.bean.getTargets();
                this.targetActionListener = this.bean.getTargetActionListener();
            } else {
                Target[] realTargets = this.retriever.getTargets(this.taskid, this.retrieverTargets);
                CommonTargetingTaskletExit exit = new CommonTargetingTaskletExit(this.retriever, this.taskid, this.multiSelect, this.type, realTargets);
                Map actionMap = exit.getActionMap();
                Object retValue = tasklet.invokeExitOnClient(exit);
                if (retValue instanceof HException) {
                    throw new HException((HException)retValue);
                }
                exit = (CommonTargetingTaskletExit)retValue;
                ObjectId[] selectedIds = exit.getSelectedTargetIds();
                if (selectedIds != null) {
                    Trace.trace(TRACE_MASKF, "selected ids length=" + selectedIds.length);
                    this.selectedTargets = new Target[selectedIds.length];
                    int i = 0;
                    while (i < selectedIds.length) {
                        int j = 0;
                        while (j < realTargets.length && this.selectedTargets[i] == null) {
                            if (selectedIds[i].equals(realTargets[j].getObjectId())) {
                                Trace.trace(TRACE_MASKF, "selectedTargets[" + i + "] has id=[" + selectedIds[i] + "]");
                                this.selectedTargets[i] = realTargets[j];
                            }
                            ++j;
                        }
                        ++i;
                    }
                } else {
                    this.selectedTargets = null;
                }
                Object actionKey = exit.getTargetActionListenerKey();
                this.targetActionListener = actionKey != null ? (TargetActionListener)actionMap.get(actionKey) : null;
            }
            if (this.selectedTargets != null) {
                int i = 0;
                while (i < this.selectedTargets.length) {
                    Trace.trace(TRACE_MASKF, "target id #" + i + " is [" + this.selectedTargets[i].getObjectId() + "]");
                    ++i;
                }
            } else {
                Trace.trace(TRACE_MASKF, "selectedTargets is null");
            }
            this.panelCompleted = true;
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKF, "Exception caught in CommonTargeting");
            Trace.trace(TRACE_MASKF, e);
            throw new HException(e);
        }
        Trace.trace(TRACE_MASKF, "<- CommonTargeting.show()");
    }

    public Target[] getSelectedTargets() {
        return this.selectedTargets;
    }

    public int getType() {
        return this.type;
    }

    public String getTaskId() {
        return this.taskid;
    }

    public TargetRetriever getTargetRetriever() {
        return this.retriever;
    }

    public TargetActionListener getTargetActionListener() {
        return this.targetActionListener;
    }

    public void performAction() throws HException {
        if (!this.panelCompleted) {
            throw new IllegalStateException("Panel not completed by user.");
        }
        if (this.targetActionListener == null) {
            throw new IllegalStateException("Null target action listener.");
        }
        if (this.panelTasklet != null && this.targetActionListener instanceof NextTargetsActionListener) {
            ((NextTargetsActionListener)this.targetActionListener).performNextAction(this.selectedTargets, this.panelTasklet);
        } else {
            this.targetActionListener.performAction(this.selectedTargets);
        }
    }
}

